//********************************************************************
//  IncDecGUI.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 4.14 (5E, p. 204)
//********************************************************************

import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;

public class IncDecGUI
{
   private int WIDTH = 100;
   private int HEIGHT = 90;
   private int INITIAL_NUMBER = 50;

   private JFrame frame;
   private JPanel panel;
   private JLabel numberLabel;
   private JButton incButton, decButton;
   private int number;

   //-----------------------------------------------------------------
   //  Sets up the GUI.
   //-----------------------------------------------------------------
   public IncDecGUI()
   {
      frame = new JFrame ("Random Numbers");
      frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);

      number = INITIAL_NUMBER;

      numberLabel = new JLabel (String.valueOf(number));

      incButton = new JButton("Increment");
      incButton.addActionListener (new IncListener());

      decButton = new JButton("Decrement");
      decButton.addActionListener (new DecListener());

      panel = new JPanel();
      panel.setPreferredSize (new Dimension(WIDTH, HEIGHT));
      panel.add (numberLabel);
      panel.add(incButton);
      panel.add(decButton);

      frame.getContentPane().add (panel);
   }

   //-----------------------------------------------------------------
   //  Displays the primary application frame.
   //-----------------------------------------------------------------
   public void display()
   {
      frame.pack();
      frame.setVisible(true);
   }

   //*****************************************************************
   //  Represents an action listener for the increment button.
   //*****************************************************************
   private class IncListener implements ActionListener
   {
      //--------------------------------------------------------------
      //  Increments and displays the current number
      //--------------------------------------------------------------
      public void actionPerformed (ActionEvent event)
      {
         numberLabel.setText (Integer.toString (++number));
      }
   }

   //*****************************************************************
   //  Represents an action listener for the decrement button.
   //*****************************************************************
   private class DecListener implements ActionListener
   {
      //--------------------------------------------------------------
      //  Decrements and displays the current number
      //--------------------------------------------------------------
      public void actionPerformed (ActionEvent event)
      {
         numberLabel.setText (Integer.toString (--number));
      }
   }
}
